﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Towary" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Types" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Obroty towarów</title>

    <script runat="server">
        public class ParametryBase : Soneta.Business.ContextBase {
            public ParametryBase(Soneta.Business.Context cx) : base(cx) {
            }
            
            bool pozaOkresem = false;
            
            [Soneta.Types.Caption("Operacje poza okresem")]
            public bool PozaOkresem {
                get { return pozaOkresem; }
                set { pozaOkresem = value; OnChanged(EventArgs.Empty); }
            }
        }
        
        static ParametryBase parametry;
        
        [Soneta.Business.Context]
        public static ParametryBase Parametry {
            get { return parametry; }
            set { parametry = value; }
        }
        
        void OnContextLoad(Object sender, EventArgs args)
        {
            Soneta.Magazyny.ObrotyParams op = (Soneta.Magazyny.ObrotyParams)dc[typeof(Soneta.Magazyny.ObrotyParams)];

            if( op.OkresCzasu.From.IsNull ) {
                cPrzedOkresem2.Visible = false;
                cStanMagaynuPrzedOkresem.Visible = false;
                cWartośćMagazynuPrzedOkresem.Visible = false;
            }

            if (Parametry.PozaOkresem) {
                cPrzedCap.Visible = true;
                cPrzedIlo.Visible = true;
                cPrzedWar.Visible = true;
                cPoCap.Visible = true;
                cPoIlo.Visible = true;
                cPoWar.Visible = true;
                cPoRCap.Visible = true;
                cPoRMag.Visible = true;
                cPoRZam.Visible = true;
            }
            else {
                cPrzedCap.Visible = false;
                cPrzedIlo.Visible = false;
                cPrzedWar.Visible = false;
                cPoCap.Visible = false;
                cPoIlo.Visible = false;
                cPoWar.Visible = false;
                cPoRCap.Visible = false;
                cPoRMag.Visible = false;
                cPoRZam.Visible = false;                
            }
            this.ReportHeader.Title += WydrukiTools.WydrukiObrotyWgTowaryLista.FilterInfo(op); 
        }        
    </script>

    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>
<body>
    <form method="post" runat="server">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad" Landscape="true"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" runat="server" Title="Obroty towarów|</strong>"></eb:ReportHeader>
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Handel"
            RowsInRow="3">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." RowSpan="3" runat="server" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn Caption=" " runat="server"></ea:GridColumn>
                <ea:GridColumn Align="Left" DataMember="Kod" Caption="Kod towaru" runat="server" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn Align="Left" DataMember="Nazwa" Total="Info" Caption="Nazwa towaru" runat="server" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn ID="cPrzedCap" Caption="Wcześniejsze rozchody pokryte z bieżącego okresu" runat="server"></ea:GridColumn>
                <ea:GridColumn ID="cPrzedIlo" Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.IlośćPrzedOkresem" Caption="Ilość" runat="server" EncodeHTML="true"> </ea:GridColumn>
                <ea:GridColumn ID="cPrzedWar" Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.WartośćPrzychod&#243;wPrzedOkresem" Caption="Wartość" Format="{0:n}" runat="server" Total="Sum" EncodeHTML="true"> </ea:GridColumn>
                <ea:GridColumn ID="cPrzedOkresem2" Caption="Przed okresem" runat="server"></ea:GridColumn>
                <ea:GridColumn ID="cStanMagaynuPrzedOkresem" Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.StanPrzed.StanMagazynu" Caption="Stan mag." runat="server" EncodeHTML="true"> </ea:GridColumn>
                <ea:GridColumn ID="cWartośćMagazynuPrzedOkresem" Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.StanPrzed.WartośćMagazynu" Caption="Wartość mag." Format="{0:n}" runat="server" Total="Sum" EncodeHTML="true"> </ea:GridColumn>
                <ea:GridColumn Caption="Przychody" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.IlośćPrzychoduPozycji" Caption="Ilość" runat="server" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.WartośćPrzychod&#243;w" Total="Sum" Caption="Wartość" Format="{0:n}" runat="server" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn Caption="Rozchody" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.Ilość" Caption="Ilość" runat="server" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.WartośćRozchod&#243;w" Total="Sum" Caption="Wartość" Format="{0:n}" runat="server" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn Caption="Rezerwacje" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.IlośćRezerwacja" Caption="Ilość" runat="server" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.WartośćPrzychoduRezerwacja" Total="Sum" Caption="Wartość" Format="{0:n}" runat="server" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn Caption="Po okresie" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.StanPo.StanMagazynu" Caption="Stan mag." runat="server" EncodeHTML="true"> </ea:GridColumn>
                <ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.StanPo.WartośćMagazynu" Caption="Wartość mag." Format="{0:n}" runat="server" Total="Sum" EncodeHTML="true"> </ea:GridColumn>
                <ea:GridColumn ID="cPoCap" Caption="Rozchody pokryte z przyszłego okresu" runat="server"></ea:GridColumn>
                <ea:GridColumn ID="cPoIlo" Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.IlośćPoOkresie" Caption="Ilość" runat="server" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn ID="cPoWar" Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.WartośćPrzychod&#243;wPoOkresie" Total="Sum" Caption="Wartość" Format="{0:n}" runat="server" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn ID="cPoRCap" Caption="Rozchody składowe pokryte z przyszłego okresu" runat="server"></ea:GridColumn>
                <ea:GridColumn ID="cPoRMag" Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.WartośćPrzychod&#243;wPoOkresieMag" Total="Sum" Caption="Magazynowe" Format="{0:n}" runat="server" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn ID="cPoRZam" Width="13" Align="Right" DataMember="Workers.ObrotyTowaru.WartośćPrzychod&#243;wPoOkresieZam" Total="Sum" Caption="Zamówione" Format="{0:n}" runat="server" EncodeHTML="True"> </ea:GridColumn>                
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" PrintDate="true" PrintTime="true">
        </eb:ReportFooter>
    </form>
</body>
</html>

